/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class TargetInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private TargetInput _inputField;
    private final JCheckBox _targetCheckBox = new JCheckBox();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel panel;
        block3: {
            panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._targetCheckBox, argOverflow);
            try {
                this._targetCheckBox.setSelected(AbstractInputField.isTrue(this._inputField.getDefaultValue()));
                if (AbstractInputField.isTrue(this._inputField.getForce())) {
                    this._targetCheckBox.setEnabled(false);
                }
                this._targetCheckBox.addActionListener(e -> {
                    this.updateInputField();
                    this._inputField.setEditted(true);
                });
            }
            catch (Exception e2) {
                this.getInstallerContext().log(e2.getMessage());
                if (!this.getInstallerContext().getInstaller().isVerbose()) break block3;
                this.getInstallerContext().log(e2);
            }
        }
        return panel;
    }

    @Override
    public void setOutputField(AbstractInputField argOutputField) {
        this._inputField = (TargetInput)argOutputField;
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            this._targetCheckBox.setSelected(AbstractInputField.isTrue(this._inputField.getDefaultValue()));
        }
    }

    @Override
    public void updateInputField() {
        String target = this._inputField.getTarget();
        int targetIdx = this._inputField.getIdx();
        boolean selected = this._targetCheckBox.isSelected();
        this._inputField.setInputResult(String.valueOf(selected));
        if (selected && !this.getInstallerContext().getCurrentPage().getAllTargets().contains(target)) {
            this.getInstallerContext().getCurrentPage().addTarget(targetIdx, target);
        } else if (!selected && this.getInstallerContext().getCurrentPage().isTarget(target)) {
            this.getInstallerContext().getCurrentPage().removeTarget(targetIdx);
        }
    }
}

