/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.util.stream.IntStream;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.PageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;

public abstract class AbstractTextPageRenderer
implements PageRenderer {
    public static final int PAGE_BLANK_LINES = 20;
    public static final int PAGE_DECO_WIDTH = 80;
    public static final String PAGE_DECO_LINE;
    public static final String BLANK_LINES;
    private static final char[] AFFIRMATIVE_CHARS;
    private Console _console;
    private InstallerContext _ctx;

    private static char[] parseChars(String commaSeparated) {
        char[] input = commaSeparated.toCharArray();
        char[] theChars = new char[input.length];
        int j = 0;
        for (char element : input) {
            if (Character.isWhitespace(element) || ',' == element) continue;
            theChars[j++] = element;
        }
        char[] toReturn = new char[j];
        System.arraycopy(theChars, 0, toReturn, 0, j);
        return toReturn;
    }

    @Override
    public InstallerContext getContext() {
        return this._ctx;
    }

    @Override
    public abstract boolean renderPage(Page var1) throws InstallException;

    @Override
    public void setContext(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    protected Console getConsole() {
        if (this._console == null) {
            this._console = System.console();
            if (this._console == null) {
                throw new IllegalStateException("Console not available!");
            }
        }
        return this._console;
    }

    protected boolean isTrue(String entered) {
        if (entered.length() == 0) {
            return true;
        }
        char first = entered.charAt(0);
        boolean isTrue = false;
        for (char affimativeChar : AFFIRMATIVE_CHARS) {
            isTrue |= Character.toUpperCase(first) == affimativeChar;
        }
        return isTrue;
    }

    protected void printHeader(Page page) {
        this.getConsole().format(BLANK_LINES, new Object[0]);
        this.getConsole().format(PAGE_DECO_LINE + "%n", new Object[0]);
        StringBuilder titleLine = new StringBuilder(page.getDisplayText()).insert(0, ' ').append(' ');
        while (titleLine.length() < 80) {
            titleLine.insert(0, '~');
            if (titleLine.length() >= 80) continue;
            titleLine.append('~');
        }
        this.getConsole().format("%s%n", titleLine.toString());
        this.getConsole().format(PAGE_DECO_LINE + "%n%n%n%n", new Object[0]);
    }

    static {
        StringBuilder tildeLine = new StringBuilder();
        IntStream.range(0, 80).forEach(e -> tildeLine.append('~'));
        PAGE_DECO_LINE = tildeLine.toString();
        StringBuilder pageBlankLines = new StringBuilder();
        IntStream.range(0, 20).forEach(e -> pageBlankLines.append("%n"));
        BLANK_LINES = pageBlankLines.toString();
        AFFIRMATIVE_CHARS = AbstractTextPageRenderer.parseChars(ResourceHelper.getResourceString("affirmativeChars"));
    }
}

