/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.runtime.exe.LoadConfigFilter;

public class InputStreamLoadConfigFilter
extends LoadConfigFilter {
    @Override
    public void exec(InstallerContext argCtx) throws InstallException {
        this.setCtx(argCtx);
        try {
            String configFilePath = "/" + argCtx.getInstallerConfigFile();
            URL config = this.getClass().getResource(configFilePath);
            if (config == null) {
                throw new IOException("Could not find installer config file at: " + configFilePath);
            }
            this.readConfig(argCtx.getFileRoot(), config.toURI());
            argCtx.setInstaller(this.getInstaller());
            argCtx.log("Config loaded");
        }
        catch (IOException | URISyntaxException e) {
            throw new InstallException("Not able to load and read the AntInstaller config", e);
        }
    }
}

