/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.CaseInsensitiveContainsTest;
import org.tp23.antinstaller.runtime.logic.CompoundExpression;
import org.tp23.antinstaller.runtime.logic.ContainsTest;
import org.tp23.antinstaller.runtime.logic.EndsWithTest;
import org.tp23.antinstaller.runtime.logic.EqualsTest;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.antinstaller.runtime.logic.GreaterThanOrEqualsTest;
import org.tp23.antinstaller.runtime.logic.LessThanOrEqualsTest;
import org.tp23.antinstaller.runtime.logic.LogicalAndTest;
import org.tp23.antinstaller.runtime.logic.LogicalOrTest;
import org.tp23.antinstaller.runtime.logic.LogicalTest;
import org.tp23.antinstaller.runtime.logic.NotEqualsTest;
import org.tp23.antinstaller.runtime.logic.SimpleExpression;
import org.tp23.antinstaller.runtime.logic.SingleExpressionTest;
import org.tp23.antinstaller.runtime.logic.StartsWithTest;
import org.tp23.antinstaller.runtime.logic.StringLengthComparator;
import org.tp23.antinstaller.runtime.logic.TestOperator;
import org.tp23.antinstaller.runtime.logic.ValuesTest;

public final class ExpressionBuilder {
    private static final char GROUPING_START_OPERATOR = '(';
    private static final char GROUPING_END_OPERATOR = ')';
    private static final ValuesTest[] TEST_VALUE_CONDITIONS = new ValuesTest[]{new EndsWithTest(), new EqualsTest(), new GreaterThanOrEqualsTest(), new LessThanOrEqualsTest(), new NotEqualsTest(), new StartsWithTest(), new ContainsTest(), new CaseInsensitiveContainsTest()};
    private static final LogicalTest[] TEST_LOGICAL_CONDITIONS = new LogicalTest[]{new LogicalAndTest(), new LogicalOrTest()};
    private static final SingleExpressionTest SINGLE_EXPRESSION_TEST = new SingleExpressionTest();
    private static Map<String, TestOperator> tokenMap = new HashMap<String, TestOperator>();
    private static final String[] VALUE_TOKENS;
    private static final String[] LOGICAL_TOKENS;

    public static Expression parseLogicalExpressions(ResultContainer container, String exprStr) throws ConfigurationException {
        int endIndex;
        int startIndex = ExpressionBuilder.skipWhiteSpace(exprStr, 0);
        int index = exprStr.indexOf(40, startIndex);
        if (index == -1) {
            return ExpressionBuilder.getSimpleExpression(container, exprStr.substring(startIndex));
        }
        if (index != 0) {
            throw new ConfigurationException("Illegal ifProperty value: If present, grouping operator ( must be at start of property string");
        }
        if ((endIndex = exprStr.indexOf(41, ++startIndex)) == -1) {
            throw new ConfigurationException("Missing closing grouping bracket ) in expression " + exprStr);
        }
        int tstIndex = exprStr.indexOf(40, startIndex);
        if (tstIndex != -1 && tstIndex < endIndex) {
            throw new ConfigurationException("Nesting of logical operations is not supported: " + exprStr);
        }
        try {
            Expression expr1 = ExpressionBuilder.parseLogicalExpressions(container, exprStr.substring(startIndex, endIndex));
            LogicalTest test = null;
            startIndex = endIndex + 1;
            String logicalToken = ExpressionBuilder.getLogicalToken(exprStr, startIndex);
            for (String logicalToken2 : LOGICAL_TOKENS) {
                if (logicalToken2.compareTo(logicalToken) != 0) continue;
                test = (LogicalTest)tokenMap.get(logicalToken2);
                index = exprStr.indexOf(logicalToken2, startIndex);
                startIndex = index + logicalToken2.length();
                break;
            }
            if (test == null) {
                return new CompoundExpression(expr1, SINGLE_EXPRESSION_TEST, null);
            }
            startIndex = ExpressionBuilder.skipWhiteSpace(exprStr, startIndex);
            String expr2Str = exprStr.substring(startIndex, exprStr.length());
            return new CompoundExpression(expr1, test, ExpressionBuilder.parseLogicalExpressions(container, expr2Str));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid ifProperty expression", e);
        }
    }

    private static String getLogicalToken(String str, int startIndex) {
        int tokenStart;
        char chr;
        int endIndex;
        int strLen = str.length();
        for (endIndex = tokenStart = ExpressionBuilder.skipWhiteSpace(str, startIndex); endIndex < strLen && (chr = str.charAt(endIndex)) != ' ' && chr != '\t' && chr != '('; ++endIndex) {
        }
        return str.substring(tokenStart, endIndex);
    }

    private static Expression getSimpleExpression(ResultContainer resultContainer, String exprStr) throws ConfigurationException {
        try {
            int i;
            int index = -1;
            for (i = 0; i < VALUE_TOKENS.length && (index = exprStr.indexOf(VALUE_TOKENS[i])) == -1; ++i) {
            }
            return new SimpleExpression(resultContainer, exprStr.substring(0, index), (ValuesTest)tokenMap.get(VALUE_TOKENS[i]), exprStr.substring(index + VALUE_TOKENS[i].length()));
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid ifProperty expression", e);
        }
    }

    private static int skipWhiteSpace(String str, int startIndex) {
        int index;
        int strLen = str.length();
        for (index = startIndex; index < strLen && (str.charAt(index) == ' ' || str.charAt(index) == '\t'); ++index) {
        }
        return index;
    }

    private ExpressionBuilder() {
    }

    static {
        for (ValuesTest testValueCondition : TEST_VALUE_CONDITIONS) {
            String[] tmpTokens;
            for (String tmpToken : tmpTokens = testValueCondition.getTestTokens()) {
                tokenMap.put(tmpToken, testValueCondition);
            }
        }
        VALUE_TOKENS = new String[tokenMap.size()];
        int index = 0;
        for (ValuesTest testValueCondition : TEST_VALUE_CONDITIONS) {
            String[] tmpTokens;
            for (String tmpToken : tmpTokens = testValueCondition.getTestTokens()) {
                ExpressionBuilder.VALUE_TOKENS[index++] = tmpToken;
            }
        }
        StringLengthComparator lengthComparator = new StringLengthComparator();
        Arrays.sort(VALUE_TOKENS, lengthComparator);
        index = 0;
        int mapInitialSize = tokenMap.size();
        for (LogicalTest testLogicalCondition : TEST_LOGICAL_CONDITIONS) {
            String[] tmpTokens;
            String[] stringArray = tmpTokens = testLogicalCondition.getTestTokens();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String tmpToken = stringArray[i];
                tokenMap.put(tmpToken, testLogicalCondition);
            }
        }
        LOGICAL_TOKENS = new String[tokenMap.size() - mapInitialSize];
        for (LogicalTest testLogicalCondition : TEST_LOGICAL_CONDITIONS) {
            String[] tmpTokens;
            for (String tmpToken : tmpTokens = testLogicalCondition.getTestTokens()) {
                ExpressionBuilder.LOGICAL_TOKENS[index++] = tmpToken;
            }
        }
        Arrays.sort(LOGICAL_TOKENS, lengthComparator);
    }
}

