/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.util;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.runtime.exe.LoadConfigFilter;
import org.tp23.antinstaller.util.LangPackFileRenderer;

public final class CreateLanguagePack {
    public static File guiMain(JFrame root) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Select antinstall-config.xml file");
            chooser.setApproveButtonText("Select file");
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().equals("antinstall-config.xml") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "antinstall-config.xml files";
                }
            };
            chooser.setFileFilter(ff);
            chooser.showOpenDialog(root);
            File chosen = chooser.getSelectedFile();
            if (chosen != null) {
                chooser = new JFileChooser();
                chooser.setDialogTitle("Select output directory");
                chooser.setApproveButtonText("Internationalise file");
                chooser.setFileSelectionMode(1);
                chooser.setCurrentDirectory(chosen.getParentFile());
                chooser.showOpenDialog(root);
                File dir = chooser.getSelectedFile();
                if (dir != null) {
                    CreateLanguagePack.createLanguagePack(CreateLanguagePack.loadConfigFile(chosen.getParentFile(), chosen.getName()), null, dir);
                    if (!dir.getName().equals("resources")) {
                        JOptionPane.showMessageDialog(root, "When the resources files are added to the installer jar\n the parent directory must be /resources/");
                    }
                    return new File(dir, "LanguagePack.properties");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstallException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String locale;
            Console con = System.console();
            if (con != null) {
                String in = con.readLine("Create LanguagePack for antinstall-config.xml in the current directory?: ", new Object[0]);
                if (!Boolean.parseBoolean(in)) {
                    return;
                }
                in = con.readLine("Enter Locale to create e.g. es_EU: ", new Object[0]);
                locale = in.trim();
                Locale specifiedLocale = Locale.forLanguageTag(locale.replace('_', '-'));
                if (specifiedLocale == null || specifiedLocale.getLanguage() == null || specifiedLocale.getLanguage().isEmpty()) {
                    throw new InstallException("Unrecognizable locale string provided: " + locale);
                }
            } else {
                throw new IllegalStateException("No console available!");
            }
            CreateLanguagePack.createLanguagePack(CreateLanguagePack.loadConfigFile(new File("."), "antinstall-config.xml"), locale, new File("."));
            con.format("done.%n", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstallException e) {
            e.printStackTrace();
        }
    }

    private static void createLanguagePack(Installer installer, String locale, File outputDir) throws IOException {
        LangPackFileRenderer renderer = new LangPackFileRenderer();
        renderer.renderProperties(installer, outputDir, locale);
    }

    private static Installer loadConfigFile(File rootDir, String configName) throws InstallException {
        InstallerContext ctx = new InstallerContext();
        ctx.setFileRoot(rootDir);
        ctx.setInstallerConfigFile(configName);
        LoadConfigFilter configLoader = new LoadConfigFilter();
        configLoader.exec(ctx);
        return ctx.getInstaller();
    }

    private CreateLanguagePack() {
    }
}

