/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.util;

import java.util.Arrays;
import java.util.Locale;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.Validator;

public class InstallTypeValidator
implements Validator {
    private static final String[] _validInstallTypeString = new String[]{"install", "update", "upgrade", "patch"};

    @Override
    public String getErrorMessage(Throwable argEx, Locale argL) {
        if (argEx instanceof InvalidInputException) {
            return "Input must contain only a single install type " + Arrays.toString(_validInstallTypeString) + " or set of install types separated by commas.";
        }
        if (argEx instanceof CannotCombinePatchException) {
            return "The install type \"patch\" cannot be combined with any other install type.";
        }
        if (argEx instanceof InvalidInstallTypeException) {
            return "The provided install type \"" + ((InvalidInstallTypeException)argEx).getType() + "\" is not supported.  Please provide only valid install types " + Arrays.toString(_validInstallTypeString) + ".";
        }
        return "An unknown validation error occurred.";
    }

    @Override
    public void validate(String argText, InstallerContext argCtx) throws ValidationException {
        String[] installTypes;
        if (!argText.matches("[a-z,]+")) {
            throw new InvalidInputException();
        }
        for (String installType : installTypes = argText.split(",")) {
            if (this.isValidType(installType)) continue;
            throw new InvalidInstallTypeException(installType);
        }
        for (String installType : installTypes) {
            if (!"patch".equals(installType) || installTypes.length <= 1) continue;
            throw new CannotCombinePatchException();
        }
    }

    private boolean isValidType(String argType) {
        for (String supportedType : _validInstallTypeString) {
            if (!supportedType.equals(argType)) continue;
            return true;
        }
        return false;
    }

    private static class InvalidInstallTypeException
    extends ValidationException {
        private static final long serialVersionUID = 1L;
        private final String _type;

        InvalidInstallTypeException(String argType) {
            this._type = argType;
        }

        String getType() {
            return this._type;
        }
    }

    private static class InvalidInputException
    extends ValidationException {
        private static final long serialVersionUID = 1L;

        InvalidInputException() {
        }
    }

    private static class CannotCombinePatchException
    extends ValidationException {
        private static final long serialVersionUID = 1L;

        CannotCombinePatchException() {
        }
    }
}

