/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.page.Page;

public class LangPackFileRenderer {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final char[] HEXIDECIMALS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void renderProperties(Installer installer, File baseDir, String locale) throws IOException {
        Page[] pages = installer.getPages();
        Object filename = locale == null ? "LanguagePack.properties" : "LanguagePack_" + locale + ".properties";
        File languagePack = new File(baseDir.getAbsolutePath(), (String)filename);
        try (OutputStreamWriter propertiesData = new OutputStreamWriter((OutputStream)new FileOutputStream(languagePack), StandardCharsets.ISO_8859_1);){
            ((Writer)propertiesData).append("### Ant Installer - language pack auto generated on ");
            ((Writer)propertiesData).append(new Date().toString());
            ((Writer)propertiesData).append(NEW_LINE);
            ((Writer)propertiesData).append(NEW_LINE);
            ((Writer)propertiesData).append("finishButtonText = ").append(installer.getFinishButtonText());
            ((Writer)propertiesData).append(NEW_LINE);
            ((Writer)propertiesData).append(NEW_LINE);
            for (Page page : pages) {
                List<AbstractInputField> fields = page.getOutputFields();
                ((Writer)propertiesData).append(NEW_LINE);
                ((Writer)propertiesData).append("## Text from Page:").append(page.getName());
                ((Writer)propertiesData).append(NEW_LINE);
                String value = this.convert(page.getDisplayText(), false);
                ((Writer)propertiesData).append("page.").append(page.getName()).append(".displayText").append(" = ").append(value);
                ((Writer)propertiesData).append(NEW_LINE);
                this.retrievePropertiesData(fields, propertiesData);
            }
        }
    }

    private String convert(String input, boolean doSpaces) {
        if (input == null) {
            return "";
        }
        int num = input.length();
        StringBuffer sb = new StringBuffer(num);
        block12: for (int i = 0; i < num; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || doSpaces) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block12;
                }
                case '=': {
                    sb.append("\\=");
                    continue block12;
                }
                case ':': {
                    sb.append("\\:");
                    continue block12;
                }
                case '#': {
                    sb.append("\\#");
                    continue block12;
                }
                case '!': {
                    sb.append("\\!");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("\\u").append(this.hex(c >> 12 & 0xF)).append(this.hex(c >> 8 & 0xF)).append(this.hex(c >> 4 & 0xF)).append(this.hex(c & 0xF));
                        continue block12;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private char hex(int val) {
        return HEXIDECIMALS[val & 0xF];
    }

    private void retrievePropertiesData(List<AbstractInputField> fields, Appendable propertiesData) throws IOException {
        String property = null;
        String value = null;
        String explProperty = null;
        String explValue = null;
        Iterator<AbstractInputField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            Object option;
            int o;
            AbstractInputField selectInput;
            AbstractInputField field;
            AbstractInputField iField = field = iterator.next();
            property = iField.getProperty() + ".displayText";
            value = this.convert(iField.getDisplayText(), false);
            propertiesData.append(property + " = " + value);
            propertiesData.append(NEW_LINE);
            if (iField.getExplanatoryText() != null && iField.getExplanatoryText().trim().length() > 0) {
                explProperty = iField.getProperty() + ".explanatoryText";
                explValue = this.convert(iField.getExplanatoryText(), false);
                propertiesData.append(explProperty + " = " + explValue);
                propertiesData.append(NEW_LINE);
            }
            if (iField instanceof SelectInput) {
                selectInput = (SelectInput)iField;
                for (o = 0; o < ((SelectInput)selectInput).getOptions().size(); ++o) {
                    option = ((SelectInput)selectInput).getOptions().get(o);
                    property = selectInput.getProperty() + "." + (o + 1) + ".displayText";
                    value = this.convert(((SelectInput.Option)option).getText(), false);
                    propertiesData.append(property + " = " + value);
                    propertiesData.append(NEW_LINE);
                }
            }
            if (!(field instanceof LargeSelectInput)) continue;
            selectInput = (LargeSelectInput)iField;
            for (o = 0; o < ((LargeSelectInput)selectInput).getOptions().size(); ++o) {
                option = ((LargeSelectInput)selectInput).getOptions().get(o);
                property = selectInput.getProperty() + "." + (o + 1) + ".displayText";
                value = this.convert(((LargeSelectInput.Option)option).getText(), false);
                propertiesData.append(property + " = " + value);
                propertiesData.append(NEW_LINE);
            }
        }
    }
}

